﻿using Silk.NET.OpenAL;


namespace GameEngine.Audio
{
    public unsafe class AudioDevice : IDisposable
    {
        public IList<Sound> Sounds { get; private set; }
        private Device* devicePtr;
        private Context* contextPtr;


        public AudioDevice()
        {
            this.Sounds = new List<Sound>();
        }


        public bool Init()
        {
            devicePtr = ALContext.GetApi().OpenDevice(String.Empty);

            if (devicePtr == null)
            {
                System.Console.WriteLine("Audio Init Error");
                return false;
            }

            int[] attribute = new int[0];
            fixed (int* a = attribute)
            {
                contextPtr = ALContext.GetApi().CreateContext(devicePtr, a);
            }

            ALContext.GetApi().MakeContextCurrent(contextPtr);

            return true;
        }


        public void Play(int key)
        {
            Sound? sound = GetSound(key);
            if (sound == null) return;

            sound.Play();
        }


        public void Stop(int key)
        {
            Sound? sound = GetSound(key);
            if (sound == null) return;

            sound.Stop();
        }


        public void StopAllLooping()
        {
            for (int i = 0; i < Sounds.Count; i++)
            {
                Sound sound = Sounds[i];
                if (sound.IsLooped)
                {
                    sound.Stop();
                }
            }
        }


        private Sound? GetSound(int key)
        {
            for (int i = 0; i < Sounds.Count; i++)
            {
                Sound sound = Sounds[i];

                if (sound.Key == key) return sound;
            }

            return null;
        }


        public void Dispose()
        {
            for (int i = 0; i < Sounds.Count; i++)
            {
                Sound sound = Sounds[i];
                sound.Dispose();
            }

            ALContext.GetApi().DestroyContext(contextPtr);
        }

    }
}
