﻿using System.Numerics;

namespace GameEngine.Graphics.Models
{
    public class ViewCamera
    {
        public Vector3 Up { get; set; }
        public Vector3 Position { get; set; }
        public Vector3 Direction { get; set; }

        public ViewCamera()
        {
            this.Up = new Vector3(0f, 0f, -1f);
            this.Position = new Vector3(0f, 0f, 0f);
            this.Direction = new Vector3(0f, 1f, 0f);

            this.projectionXResolution = 0;
            this.projectionYResolution = 0;
            this.projectionFieldOfView = 0;
        }


        public Matrix4x4 GetViewMatrix()
        {
            this.view = Matrix4x4.CreateLookAt(Position, Direction, Up);

            return this.view;
        }


        public Matrix4x4 GetProjectionMatrix(int xResolution, int yResolution, float fieldOfView)
        {
            if((projectionXResolution == xResolution) && (projectionYResolution == yResolution) && (projectionFieldOfView == fieldOfView))
            {
                return this.projection;
            }

            float aspectRatio = (float)xResolution / (float)yResolution;
            float fieldOfViewRadians = fieldOfView / 180f * (float)Math.PI;

            this.projection = Matrix4x4.CreatePerspectiveFieldOfView(fieldOfViewRadians, aspectRatio, 1f, 10000f);

            return this.projection;
        }


        private Matrix4x4 projection;
        private int projectionXResolution;
        private int projectionYResolution;
        private float projectionFieldOfView;

        private Matrix4x4 view;
    }
}
