﻿using Silk.NET.OpenGL;

namespace GameEngine.Graphics
{
    public class ShaderManager
    {
        private readonly string executingPath;
        private IDictionary<string, string> shaderSources;
        private IDictionary<string, uint> shaderIDs;


        public ShaderManager(string executingPath)
        {
            this.executingPath = executingPath;
            this.shaderSources = new Dictionary<string, string>();
            this.shaderIDs = new Dictionary<string, uint>();
        }


        public void Load(GL gl)
        {
            DirectoryInfo directory = new DirectoryInfo(this.executingPath + "Graphics" + Path.DirectorySeparatorChar + "Shaders");
            FileInfo[] files = directory.GetFiles();

            for (int i = 0; i < files.Length; i++)
            {
                FileInfo file = files[i];

                string name = file.Name;
                string type = file.Extension;
                string source = File.ReadAllText(file.FullName);

                shaderSources.Add(name, source);

                uint id = 0;
                if (type == ".frag") id = gl.CreateShader(ShaderType.FragmentShader);
                else if (type == ".vert") id = gl.CreateShader(ShaderType.VertexShader);

                gl.ShaderSource(id, source);
                gl.CompileShader(id);

                string infoLog = gl.GetShaderInfoLog(id);
                if (!string.IsNullOrWhiteSpace(infoLog))
                {
                    Console.WriteLine($"Error compiling {type} shader {infoLog}");
                }

                shaderIDs.Add(name, id);
            }
        }


        public string GetShaderSource(string name)
        {
            if (shaderSources.ContainsKey(name))
            {
                return shaderSources[name];
            }

            return "";
        }


        public uint GetShaderID(string name)
        {
            if (shaderIDs.ContainsKey(name))
            {
                return shaderIDs[name];
            }

            return 0;
        }

    }
}
