﻿using System.Drawing;
using System.Numerics;


namespace GameEngine.Support
{
    public static class MathExtensions
    {
        public static float Distance(float ax, float ay, float bx, float by)
        {
            return MathF.Sqrt(MathF.Pow(bx - ax, 2) + MathF.Pow(by - ay, 2));
        }


        public static float FixYawAngle(float a)
        {
            if (a > (MathF.PI * 2)) return a - (MathF.PI * 2);
            if (a < 0) return a + (MathF.PI * 2);

            return a;
        }


        public static float FixPitchAngle(float a)
        {
            float max = MathF.PI - 0.01f;
            float min = 0.01f;

            if (a > max) return max;
            if (a < min) return min;

            return a;
        }


        public static Vector3 ConvertColorToVector3(Color color)
        {
            return new Vector3((float)color.R / 255f, (float)color.G / 255f, (float)color.B / 255f);
        }
    }
}
