﻿using RawResources.Models.Resources;

namespace RawResources.Repositories
{
	public class FileGraphicRepository : IRawContentRepository<GraphicDefinition>
    {
        private IDictionary<int, GraphicDefinition> contentsByKey;
        private IList<int> keys;


        public FileGraphicRepository(string filename)
        {
            this.contentsByKey = new Dictionary<int, GraphicDefinition>();
            this.keys = new List<int>();

            Load(filename);
        }


        public GraphicDefinition? GetContent(int key)
        {
            if (this.contentsByKey.ContainsKey(key))
            {
                return this.contentsByKey[key];
            }

            return null;
        }


        public void RemoveContent(int key)
        {
            if (this.contentsByKey.ContainsKey(key))
            {
                this.contentsByKey.Remove(key);
                this.keys.Remove(key);
            }
        }


        public void AddContent(GraphicDefinition content)
        {
            int key = GetMaxKey() + 1;

            content.Key = key;

            this.contentsByKey.Add(key, content);
            this.keys.Add(key);
        }


        private int GetMaxKey()
        {
            int maxKey = -1;

            foreach (int key in this.keys)
            {
                if (maxKey < key) maxKey = key;
            }

            return maxKey;
        }


        public IEnumerable<GraphicDefinition> GetAllContent()
        {
            IList<GraphicDefinition> content = new List<GraphicDefinition>();
            IEnumerable<int> keys = GetKeys();

            foreach (int key in keys)
            {
                content.Add(contentsByKey[key]);
            }

            return content;
        }


        public IEnumerable<int> GetKeys()
        {
            return this.keys;
        }


        public void Load(string filename)
        {
            Stream stream;
            StreamReader reader;
            string? line;
            string[] lineContents;

            try
            {
                stream = File.OpenRead(filename);
                reader = new StreamReader(stream);
            }
            catch (Exception e)
            {
                Console.Error.WriteLine(e.Message);
                return;
            }

            //skip first line
            reader.ReadLine();

            while ((line = reader.ReadLine()) != null)
            {
                lineContents = line.Split('|');

                LoadContent(lineContents);
            }

            reader.Close();
        }


        private void LoadContent(string[] lineContents)
        {
            if (lineContents[0].Equals("") == false)
            {
                GraphicDefinition item = new GraphicDefinition()
                {
                    Key = Int32.Parse(lineContents[0]),
                    Filename = lineContents[1],
                    Size = Int32.Parse(lineContents[2])
                };

                this.contentsByKey.Add(item.Key, item);
                this.keys.Add(item.Key);
            }
        }


        public void Save(string filename)
        {
            StreamWriter writer = new StreamWriter(filename, false);

            writer.WriteLine("Key|Filename|Size");

            foreach (int key in this.keys)
            {
                GraphicDefinition definition = this.contentsByKey[key];

                writer.Write(definition.Key);
                writer.Write("|");
                writer.Write(definition.Filename);
                writer.Write("|");
                writer.Write(definition.Size);
                writer.WriteLine("");
            }

            writer.Close();
        }

    }
}

