﻿using System;
using RawResources.Models;
using RawResources.Models.Items;

namespace RawResources.Repositories
{
	public class FileWeaponRepository : IRawContentRepository<WeaponDefinition>
    {
        private IDictionary<int, WeaponDefinition> contentsByKey;
        private IList<int> keys;


        public FileWeaponRepository(string filename)
        {
            this.contentsByKey = new Dictionary<int, WeaponDefinition>();
            this.keys = new List<int>();

            Load(filename);
        }


        public WeaponDefinition? GetContent(int key)
        {
            if (this.contentsByKey.ContainsKey(key))
            {
                return this.contentsByKey[key];
            }

            return null;
        }


        public void RemoveContent(int key)
        {
            if (this.contentsByKey.ContainsKey(key))
            {
                this.contentsByKey.Remove(key);
                this.keys.Remove(key);
            }
        }


        public void AddContent(WeaponDefinition content)
        {
            int key = GetMaxKey() + 1;

            content.Key = key;

            this.contentsByKey.Add(key, content);
            this.keys.Add(key);
        }


        private int GetMaxKey()
        {
            int maxKey = -1;

            foreach (int key in this.keys)
            {
                if (maxKey < key) maxKey = key;
            }

            return maxKey;
        }


        public IEnumerable<WeaponDefinition> GetAllContent()
        {
            IList<WeaponDefinition> content = new List<WeaponDefinition>();
            IEnumerable<int> keys = GetKeys();

            foreach (int key in keys)
            {
                content.Add(contentsByKey[key]);
            }

            return content;
        }


        public IEnumerable<int> GetKeys()
        {
            return this.keys;
        }


        public void Load(string filename)
        {
            Stream stream;
            StreamReader reader;
            string? line = null;
            string[] lineContents;

            try
            {
                stream = File.OpenRead(filename);
                reader = new StreamReader(stream);
            }
            catch (Exception e)
            {
                Console.Error.WriteLine(e.Message);
                return;
            }

            //skip first line
            reader.ReadLine();

            while ((line = reader.ReadLine()) != null)
            {
                lineContents = line.Split('|');

                LoadContent(lineContents);
            }

            reader.Close();
        }


        private void LoadContent(string[] lineContents)
        {
            if (lineContents[0].Equals("") == false)
            {
                WeaponDefinition item = new WeaponDefinition()
                {
                    Key = Int32.Parse(lineContents[0]),
                    Name = lineContents[1],
                    AmmoPerClip = Int32.Parse(lineContents[2]),
                    TextureKey = Int32.Parse(lineContents[3]),
                    InventorySlot = Int32.Parse(lineContents[4]),
                    SemiAutomatic = Boolean.Parse(lineContents[5]),
                    UnlimitedAmmo = Boolean.Parse(lineContents[6]),
                    FireRecoil = float.Parse(lineContents[7]),
                    TimeBetweenFire = Int32.Parse(lineContents[8]),
                    SoundKey = Int32.Parse(lineContents[9]),
                    MuzzleFlashOffsetX = float.Parse(lineContents[10]),
                    MuzzleFlashOffsetY = float.Parse(lineContents[11]),
                    HasMuzzleFlash = Boolean.Parse(lineContents[12]),
                    AmmoTypeKey = Int32.Parse(lineContents[13]),
                    Damage = Int32.Parse(lineContents[14]),
                    CrosshairTextureKey = Int32.Parse(lineContents[15])
                };

                this.contentsByKey.Add(item.Key, item);
                this.keys.Add(item.Key);
            }
        }


        public void Save(string filename)
        {
            StreamWriter writer = new StreamWriter(filename, false);

            writer.WriteLine("Key|Name|AmmoPerClip|TextureKey|InventorySlot|SemiAutomatic|UnlimitedAmmo|FireRecoil|TimeBetweenFire|SoundKey|MuzzleFlashOffsetX|MuzzleFlashOffsetY|HasMuzzleFlash|AmmoTypeKey|Damage|CrosshairTextureKey");

            foreach (int key in this.keys)
            {
                WeaponDefinition definition = this.contentsByKey[key];

                writer.Write(definition.Key);
                writer.Write("|");
                writer.Write(definition.Name);
                writer.Write("|");
                writer.Write(definition.AmmoPerClip);
                writer.Write("|");
                writer.Write(definition.TextureKey);
                writer.Write("|");
                writer.Write(definition.InventorySlot);
                writer.Write("|");
                writer.Write(definition.SemiAutomatic);
                writer.Write("|");
                writer.Write(definition.UnlimitedAmmo);
                writer.Write("|");
                writer.Write(definition.FireRecoil);
                writer.Write("|");
                writer.Write(definition.TimeBetweenFire);
                writer.Write("|");
                writer.Write(definition.SoundKey);
                writer.Write("|");
                writer.Write(definition.MuzzleFlashOffsetX);
                writer.Write("|");
                writer.Write(definition.MuzzleFlashOffsetY);
                writer.Write("|");
                writer.Write(definition.HasMuzzleFlash);
                writer.Write("|");
                writer.Write(definition.AmmoTypeKey);
                writer.Write("|");
                writer.Write(definition.Damage);
                writer.Write("|");
                writer.Write(definition.CrosshairTextureKey);
                writer.WriteLine("");
            }

            writer.Close();
        }

    }
}

