﻿using System.Numerics;
using GameEngine.Graphics;
using GameEngine.Graphics.Models;
using GameEngine.Input;

namespace FirstPersonShooter.Controls
{
	public class ImageControl : IControl
	{
        private readonly GraphicsDevice graphicsDevice;
        private Quad? quad;
        private readonly float depth;


        public ImageControl(MyGame game, string textureName, Vector2 absolutePoint1, Vector2 absolutePoint2, float depth)
		{
            this.graphicsDevice = game.GraphicsDevice;
            QuadHelper quadHelper = new QuadHelper(game.GraphicsDevice);
            this.depth = depth;

            Texture? texture = game.TextureManager.GetTextureByName(textureName);

            if (texture != null)
            {
                this.quad = quadHelper.MakeQuadForUIFromAbsolute(texture, absolutePoint1, absolutePoint2, this.depth);
            }
        }


        public void Draw()
        {
            if (this.quad != null)
            {
                this.graphicsDevice.DrawQuadRelative(this.quad);
            }
        }


        public void Update(InputState inputState)
        {
            //nothing    
        }

    }
}

