﻿using System.Numerics;
using FirstPersonShooter.Models;
using GameEngine.Graphics;
using RawResources;

namespace FirstPersonShooter.Factories
{
	public class EffectsFactory
	{
        private readonly IRawContentManager rawContentManager;
        private readonly TextureManager textureManager;
        private Texture[] poofTextures;
        private Texture[] explosionTextures;
        private Texture[] fireTextures;
        private Texture[] chemicalExplosionTextures;

        public EffectsFactory(IRawContentManager rawContentManager, TextureManager textureManager)
        {
            this.rawContentManager = rawContentManager;
            this.textureManager = textureManager;

            this.poofTextures = GetTextures(textureManager, "poof", 10);
            this.explosionTextures = GetTextures(textureManager, "explosion", 10);
            this.fireTextures = GetTextures(textureManager, "fire", 6);
            this.chemicalExplosionTextures = GetTextures(textureManager, "chemical explosion", 10);
        }


        private Texture[] GetTextures(TextureManager textureManager, string name, int frames)
        {
            List<Texture> textures= new List<Texture>();

            for (int i = 1; i <= frames; i++)
            {
                string n = i.ToString("0#");

                Texture? texture = textureManager.GetTextureByName("graphics/effects/" + name + " " + n + ".png");
                if (texture != null) textures.Add(texture);
            }

            return textures.ToArray();
        }


        public Effect GetPoofEffect(Vector3 position)
        {
            int maxTicks = 20;
            Texture[] textures = poofTextures;

            Effect effect = new Effect(EffectType.Poof, position, textures, maxTicks, 16, 32, 0);

            return effect;
        }


        public Effect GetExplosionEffect(Vector3 position, int damage)
        {
            int maxTicks = 20;
            Texture[] textures = explosionTextures;

            Effect effect = new Effect(EffectType.Explosion, position, textures, maxTicks, 32, 128, damage);

            return effect;
        }


    }
}

