﻿using System;
using System.Numerics;
using FirstPersonShooter.Models;
using GameEngine.Graphics;
using RawResources;
using RawResources.Models.Items;

namespace FirstPersonShooter.Factories
{
	public class PickupFactory
	{
        private readonly IRawContentManager rawContentManager;
        private readonly TextureManager textureManager;


        public PickupFactory(IRawContentManager rawContentManager, TextureManager textureManager)
        {
            this.rawContentManager = rawContentManager;
            this.textureManager = textureManager;
        }


        public Pickup? GetPickup(int pickupTypeKey, Vector3 position)
        {
            PickupDefinition? definition = this.rawContentManager.PickupRepository.GetContent(pickupTypeKey);

            if (definition != null)
            {
                Texture? texture = this.textureManager.GetTextureByKey(definition.TextureKey);

                if (texture != null)
                {
                    Pickup pickup = new Pickup(definition, texture, position);

                    return pickup;
                }
            }

            return null;
        }


    }
}

