﻿using FirstPersonShooter.Models;
using GameEngine.Audio;

namespace FirstPersonShooter.Logic
{
	public class DoorOpener
	{
		private readonly MyGame game;
		private readonly GameState gameState;


		public DoorOpener(MyGame game, GameState gameState)
		{
			this.game = game;
			this.gameState = gameState;
		}


		public bool AttemptToUseDoor(Inventory inventory, Cube searchArea)
		{
			if (this.gameState.ActiveLevel == null) return false;

			Level level = this.gameState.ActiveLevel;

			foreach(Door door in level.Doors)
			{
				Cube doorCube = door.GetCollisionCube();

				if(searchArea.Intersects(doorCube))
				{
					if (CanOpenDoor(inventory, door))
					{
						door.Activate();

                        //Play Door Activation Sound
                        Sound? sound = game.SoundManager.GetSoundByName("sounds/door.wav");
                        if (sound != null) sound.Play();

						return true;
                    }
                }
			}

			return false;
		}


		private bool CanOpenDoor(Inventory inventory, Door door)
		{
			bool can = true;

			if (door.RequiresBlueKey && inventory.HasBlueKey == false) can = false;
			if (door.RequiresGreenKey && inventory.HasGreenKey == false) can = false;
			if (door.RequiresRedKey && inventory.HasRedKey == false) can = false;

			return can;
		}


	}
}

