﻿using GameEngine.Input;

namespace FirstPersonShooter.Logic
{
	public class NodeReader
	{
		public bool IsReading { get; set; }
		public string Text { get; set; }

		private int inputTicks;
		private const int MAX_INPUT_TICKS = 10;


		public NodeReader()
		{
			this.Text = string.Empty;
			this.IsReading = false;
			this.inputTicks = 0;
		}


		public void Update(InputState inputState)
		{
			if (this.IsReading == false) return;

			if(inputTicks < MAX_INPUT_TICKS) inputTicks++;
			
			if(inputTicks >= MAX_INPUT_TICKS)
			{
				if(inputState.Use)
				{
					this.IsReading = false;
				}
			}
		}


		public void ReadText(string text)
		{
			this.Text = text;
			this.inputTicks = 0;
			this.IsReading = true;
		}


	}
}

