﻿using GameEngine.Input;
using FirstPersonShooter.Logic;


namespace FirstPersonShooter.Models
{
    public class GameState
    {
        public Level? ActiveLevel { get; set; }
        public Player? Player { get; set; }
        public CollisionDetector CollisionDetector { get; private set; }
        public Physics Physics { get; private set; }
        public BulletLauncher BulletLauncher { get; private set; }
        public NodeReader NodeReader { get; private set; }

        private MyGame game;
        

        public GameState(MyGame game)
        {
            this.game = game;

            this.CollisionDetector = new CollisionDetector(this);
            this.Physics = new Physics(this);
            this.BulletLauncher = new BulletLauncher(this, game.TextureManager);
            this.NodeReader = new NodeReader();
        }


        public void Update(MyGame game, InputState inputState)
        {
            if (this.NodeReader.IsReading == false)
            {
                if (this.Player != null) this.Player.Update(game, this, inputState);
                if (this.ActiveLevel != null) this.ActiveLevel.Update(game, this);
            }
            else 
            {
                this.NodeReader.Update(inputState);
            }
        }

    }
}
