﻿using FirstPersonShooter.Logic;
using GameEngine.Graphics.Models;

namespace FirstPersonShooter.Models
{
    public class Geometry : ICollisionObject
    {
        public bool BlocksCollision { get; set; }
        public Cube Cube { get; set; }
        public IList<Quad> Quads { get; set; }


        public Geometry()
        {
            this.BlocksCollision = true;
            this.Cube = new Cube();
            this.Quads = new List<Quad>();
        }


        public void Update()
        {
            for(int i = 0; i < this.Quads.Count; i++)
            {
                this.Quads[i].Update();
            }
        }


        public Cube GetCollisionCube()
        {
            return this.Cube;
        }


        

    }
}
