﻿using System;
using System.Numerics;
using GameEngine.Graphics;
using RawResources.Models.Items;


namespace FirstPersonShooter.Models
{
	public class Pickup
	{
        public Vector3 Position { get; private set; }
        public int Key { get; private set; }
        public string Name { get; private set; }
        public Texture Texture { get; private set; }
        public int Amount { get; private set; }
        public PickupTypes PickupType { get; private set; }
        public int AmmoTypeKey { get; private set; }
        public int WeaponKey { get; private set; }

        public static readonly int SIZE = 24;
        public static readonly int FLOAT_HEIGHT = SIZE / 8;

        public float ViewHeight { get; set; }
        public float ViewAngle { get; set; }

        
        public Pickup(PickupDefinition definition, Texture texture, Vector3 position)
		{
            this.Position = position;
            this.Texture = texture;

            this.Key = definition.Key;
            this.Name = definition.Name;
            this.Amount = definition.Amount;
            this.PickupType = definition.PickupType;
            this.AmmoTypeKey = definition.AmmoTypeKey;
            this.WeaponKey = definition.WeaponKey;

            this.ViewAngle = 0;
            this.ViewHeight = FLOAT_HEIGHT;
		}


        public Cube GetCollisionCube()
        {
            float height = SIZE;
            float halfWidth = SIZE / 2;
            float zOffset = 1;

            Vector3 p1 = new Vector3(this.Position.X - halfWidth, this.Position.Y - halfWidth, this.Position.Z - zOffset - height);
            Vector3 p2 = new Vector3(this.Position.X + halfWidth, this.Position.Y + halfWidth, this.Position.Z - zOffset);

            return new Cube(p1, p2);
        }


        public void Update()
        {
            this.ViewAngle += (MathF.PI * 2.0f) / 64.0f;
            if (this.ViewAngle > (Math.PI * 2)) this.ViewAngle -= (MathF.PI * 2);

            float dz = MathF.Sin(this.ViewAngle) * FLOAT_HEIGHT;
            this.ViewHeight = FLOAT_HEIGHT + dz;
        }



    }
}

