﻿using System;
using System.Numerics;

namespace FirstPersonShooter.Models.Save
{
	public class PlayerPlacement
	{
        public Vector3 Position { get; set; }
        public float YawAngle { get; set; }
        public float PitchAngle { get; set; }

        public int Health { get; set; }
        public int Armor { get; set; }

        public bool HasBlueKey { get; set; }
        public bool HasRedKey { get; set; }
        public bool HasGreenKey { get; set; }

        public List<WeaponAmount> Weapons { get; set; }
        public List<AmmoBagAmount> AmmoAmounts { get; set; }
        public int ActiveWeaponKey { get; set; }


        public PlayerPlacement()
		{
            this.Weapons = new List<WeaponAmount>();
            this.AmmoAmounts = new List<AmmoBagAmount>();
		}
	}
}

