﻿using FirstPersonShooter.Controls;
using FirstPersonShooter.Models;
using GameEngine.Input;

namespace FirstPersonShooter.Screen
{
	public class GameScreen : IScreen
    {
        private readonly MyGame game;
        private GameState? gameState;
        private PlayerCamera camera;


        public GameScreen(MyGame game) 
		{
            this.game = game;
            this.camera = new PlayerCamera(game);
        }


        public void Activate()
        {
            this.game.InputDevice.SetMouseMode(MouseMode.Gaming);

            this.gameState = this.game.ActiveGameState;

            this.camera.GameState = gameState;
        }


        public void Deactivate()
        {

        }


        public void Draw()
        {
            this.camera.Draw();
        }


        public void Update(InputState inputState)
        {
            if (this.game.CanDoCommonInput())
            {
                if (inputState.Menu)
                {
                    this.game.ResetCommonInput();
                    this.game.ActivateScreen(ScreenTypes.Pause);
                    return;
                }
            }

            if (this.gameState != null)
            {
                this.gameState.Update(this.game, inputState);

                if(this.gameState.Player != null)
                {
                    if (this.gameState.Player.IsVictorious)
                    {
                        this.game.ActivateScreen(ScreenTypes.GameWin);
                    }
                    else if (this.gameState.Player.IsDead)
                    {
                        this.game.ActivateScreen(ScreenTypes.GameOver);
                    }
                }
                
            }
        }

    }
}

