﻿using System.Numerics;

namespace GameEditor.Helpers
{
    public class ColorHelper
    {

        private ColorHelper()
        {

        }


        public static Vector3 GetVector(Avalonia.Media.Color color)
        {
            return new Vector3(color.R / 255f, color.G / 255f, color.B / 255f);
        }


        public static Avalonia.Media.Color GetAvaloniaColor(Vector3 vector)
        {
            byte r = (byte)((int)(vector.X * 255));
            byte g = (byte)((int)(vector.Y * 255));
            byte b = (byte)((int)(vector.Z * 255));

            return new Avalonia.Media.Color(255, r, g, b);
        }



    }
}
