﻿using Avalonia.Controls;
using Avalonia.Markup.Xaml;
using Avalonia.Media.Imaging;
using GameEditor.Models;
using RawResources.Models.Items;
using RawResources.Models.Resources;

namespace GameEditor.Panels.Main
{
	public class FontsPanel : UserControl
	{
		private Session? session;
		private IEnumerable<FontDefinition>? resources;


		public FontsPanel()
		{
			this.InitializeComponent();
		}


		private void InitializeComponent()
		{
			AvaloniaXamlLoader.Load(this);

			this.FindControl<DataGrid>("ListGridView").CurrentCellChanged += ListGridView_CurrentCellChanged;
		}


		public void SetSession(Session session)
		{
			this.session = session;

			LoadSession();
		}


		private void LoadSession()
		{
			if (this.session == null) return;
			if (this.session.RawContentManager == null) return;

			this.resources = session.RawContentManager.FontRepository.GetAllContent();

			var grid = this.FindControl<DataGrid>("ListGridView");
			grid.Items = resources;
		}


        private void AddEvents()
        {
            this.FindControl<TextBox>("QuickName").PropertyChanged += QuickName_PropertyChanged;
        }


        private void RemoveEvents()
        {
            this.FindControl<TextBox>("QuickName").PropertyChanged -= QuickName_PropertyChanged;
        }


        private void LoadComboBoxes()
        {
            if (this.session == null) return;
            if (this.session.RawContentManager == null) return;


        }


        private void RefreshForm()
        {
            if (this.session == null) return;
            if (this.session.RawContentManager == null) return;

            DataGrid grid = this.FindControl<DataGrid>("ListGridView");

            TextBox quickName = this.FindControl<TextBox>("QuickName");

            RemoveEvents();

            LoadComboBoxes();

            if (grid.SelectedItem != null)
            {
                FontDefinition font = (FontDefinition)grid.SelectedItem;

                quickName.Text = font.QuickName;
            }
            else
            {
                quickName.Text = "";
            }

            AddEvents();
        }


        private void ListGridView_CurrentCellChanged(object? sender, EventArgs e)
        {
            RefreshForm();
        }


        private void QuickName_PropertyChanged(object? sender, Avalonia.AvaloniaPropertyChangedEventArgs e)
        {
            DataGrid grid = this.FindControl<DataGrid>("ListGridView");
            TextBox textBox = this.FindControl<TextBox>("QuickName");

            if (grid.SelectedItem != null)
            {
                FontDefinition font = (FontDefinition)grid.SelectedItem;

                font.QuickName = textBox.Text;
            }
        }

    }
}

