﻿using Avalonia.Controls;
using Avalonia.Markup.Xaml;
using Avalonia.Media.Imaging;
using GameEditor.Models;
using RawResources.Models.Resources;

namespace GameEditor.Panels.Main
{
	public class GraphicsPanel : UserControl
	{
		private Session? session;
		private IEnumerable<GraphicDefinition>? resources;


		public GraphicsPanel()
		{
			this.InitializeComponent();
		}


		private void InitializeComponent()
		{
			AvaloniaXamlLoader.Load(this);

			this.FindControl<DataGrid>("ListGridView").CurrentCellChanged += ListGridView_CurrentCellChanged;
		}


		public void SetSession(Session session)
		{
			this.session = session;

			LoadSession();
		}


		private void LoadSession()
		{
			if (this.session == null) return;
			if (this.session.RawContentManager == null) return;

			this.resources = session.RawContentManager.GraphicRepository.GetAllContent();

			var grid = this.FindControl<DataGrid>("ListGridView");
			grid.Items = resources;
		}


		private void ListGridView_CurrentCellChanged(object? sender, EventArgs e)
		{
			if (this.session == null) return;

			var grid = this.FindControl<DataGrid>("ListGridView");

			if (grid.SelectedItem != null)
			{
				var image = this.FindControl<Image>("GraphicImage");
				GraphicDefinition item = (GraphicDefinition)grid.SelectedItem;
                string filename = this.session.WorkingDirectory + "/" + item.Filename;

                IBitmap bitmap = new Avalonia.Media.Imaging.Bitmap(filename);
				image.Source = bitmap;

			}
		}
	}
}

