﻿using Avalonia.Controls;
using Avalonia.Interactivity;
using Avalonia.Markup.Xaml;
using GameEditor.Models;
using LibVLCSharp.Shared;
using RawResources.Models.Resources;


namespace GameEditor.Panels.Main
{
	public class SoundsPanel : UserControl
	{
		private Session? session;
		private IEnumerable<SoundDefinition>? resources;
		private LibVLC? vlc;
		private MediaPlayer? mediaPlayer;


		public SoundsPanel()
		{
			this.InitializeComponent();
		}


		private void InitializeComponent()
		{
			AvaloniaXamlLoader.Load(this);

			this.FindControl<Button>("PlayButton").Click += PlayButton_Click;
			this.FindControl<DataGrid>("ListGridView").CurrentCellChanged += ListGridView_CurrentCellChanged;
		}


		public void SetSession(Session session)
		{
			this.session = session;

			LoadSession();
		}


		private void LoadSession()
		{
			if (this.session == null) return;
			if (this.session.RawContentManager == null) return;

			this.resources = session.RawContentManager.SoundRepository.GetAllContent();

			var grid = this.FindControl<DataGrid>("ListGridView");
			grid.Items = resources;
		}


		private void ListGridView_CurrentCellChanged(object? sender, EventArgs e)
		{

		}


		private void PlayButton_Click(object? sender, RoutedEventArgs e)
		{
			if (this.session == null) return;

			var grid = this.FindControl<DataGrid>("ListGridView");

			if (grid.SelectedItem == null) return;

			if (vlc == null || mediaPlayer == null)
			{
				this.vlc = new LibVLC();
				this.mediaPlayer = new MediaPlayer(this.vlc);
			}

			if (this.mediaPlayer.IsPlaying)
			{
				this.mediaPlayer.Stop();
			}
			else
			{
				SoundDefinition item = (SoundDefinition)grid.SelectedItem;
				string filename = this.session.WorkingDirectory + "/" + item.Filename;

				Media media = new Media(this.vlc, filename);
				this.mediaPlayer.Play(media);
			}
		}


	}
}
