﻿using System.Numerics;


namespace GameEngine.Graphics.Models
{
    public class Light
    {
        public int Key { get; set; }
        public Vector3 Color { get; private set; }
        public float Brightness { get; private set; }
        public Vector3 Position { get; private set; }


        public Light()
        {
            this.Key = -1;
            this.Position = new Vector3(0,0,0);
            this.Color = new Vector3(1, 1, 1);
            this.Brightness = 1;
        }


        public Light(int key, Vector3 position, Vector3 color, float brightness)
        {
            this.Key = key;
            this.Position = position;
            this.Color = color;
            this.Brightness = brightness;
        }

    }
}
