﻿using RawResources.Models;
using RawResources.Models.Items;
using RawResources.Models.Levels;
using RawResources.Models.Resources;
using RawResources.Repositories;

namespace RawResources
{
    public class DefaultRawContentManager : IRawContentManager
    {
        public string workingDirectory;
        public IRawContentRepository<GraphicDefinition> GraphicRepository { get; private set; }
        public IRawContentRepository<SoundDefinition> SoundRepository { get; private set; }
        public IRawContentRepository<FontDefinition> FontRepository { get; private set; }
        public IRawContentRepository<PlayerDefinition> PlayerRepository { get; private set; }
        public IRawContentRepository<LevelDefinition> LevelRepository { get; private set; }
        public IRawContentRepository<WeaponDefinition> WeaponRepository { get; private set; }
        public IRawContentRepository<PickupDefinition> PickupRepository { get; private set; }
        public IRawContentRepository<AmmoTypeDefinition> AmmoTypeRepository { get; private set; }
        public IRawContentRepository<EnemyDefinition> EnemyRepository { get; private set; }


        public DefaultRawContentManager(string path)
        {
            if (path.Equals("") == false) path += "/";
            this.workingDirectory = path;

            this.GraphicRepository = new FileGraphicRepository(this.workingDirectory + "graphics.csv");
            this.SoundRepository = new FileSoundRepository(this.workingDirectory + "sounds.csv");
            this.FontRepository = new FileFontRepository(this.workingDirectory + "fonts.csv");

            this.PlayerRepository = new FilePlayerRepository(this.workingDirectory + "player.csv");
            this.LevelRepository = new FileLevelRepository(this.workingDirectory + "levels.dat");
            this.AmmoTypeRepository = new FileAmmoTypeRepository(this.workingDirectory + "ammoTypes.csv");
            this.WeaponRepository = new FileWeaponRepository(this.workingDirectory + "weapons.csv");
            this.PickupRepository = new FilePickupRepository(this.workingDirectory + "pickups.csv");
            this.EnemyRepository = new FileEnemyRepository(this.workingDirectory + "enemies.csv");
        }


        public bool Save()
        {
            try
            {
                this.GraphicRepository.Save(this.workingDirectory + "graphics.csv");
                this.SoundRepository.Save(this.workingDirectory + "sounds.csv");
                this.FontRepository.Save(this.workingDirectory + "fonts.csv");

                this.PlayerRepository.Save(this.workingDirectory + "player.csv");
                this.LevelRepository.Save(this.workingDirectory + "levels.dat");
                this.AmmoTypeRepository.Save(this.workingDirectory + "ammoTypes.csv");
                this.WeaponRepository.Save(this.workingDirectory + "weapons.csv");
                this.PickupRepository.Save(this.workingDirectory + "pickups.csv");
                this.EnemyRepository.Save(this.workingDirectory + "enemies.csv");
            }
            catch(Exception)
            {
                return false;
            }

            return true;
        }
    }
}

