﻿using System;

namespace RawResources.Models.Items
{
	public enum PickupTypes { Health, Armor, Ammo, Weapon, RedKey, BlueKey, GreenKey }

	public class PickupDefinition
	{
        public int Key { get; set; }
        public string Name { get; set; }
		public int TextureKey { get; set; }
		public int Amount { get; set; }
		public PickupTypes PickupType { get; set; }
		public int AmmoTypeKey { get; set; }
		public int WeaponKey { get; set; }

        public PickupDefinition()
		{
			this.Key = -1;
			this.Name = string.Empty;
			this.TextureKey = -1;
			this.Amount = 0;
			this.PickupType = PickupTypes.Health;
			this.AmmoTypeKey = -1;
			this.WeaponKey = -1;
		}


        public override string ToString()
        {
			return this.Name;
        }
    }
}

