﻿using System;
namespace RawResources.Models.Items
{
	public class WeaponDefinition
	{
		public int Key { get; set; }
		public string Name { get; set; }
		public int AmmoPerClip { get; set; }
        public int TextureKey { get; set; }
		public int SoundKey { get; set; }
		public int InventorySlot { get; set; }
		public bool SemiAutomatic { get; set; }
		public float FireRecoil { get; set; }
		public int TimeBetweenFire { get; set; }
		public bool UnlimitedAmmo { get; set; }
        public bool HasMuzzleFlash { get; set; }
        public float MuzzleFlashOffsetX { get; set; }
        public float MuzzleFlashOffsetY { get; set; }
		public int AmmoTypeKey { get; set; }
		public int Damage { get; set; }
		public int CrosshairTextureKey { get; set; }


        public WeaponDefinition()
		{
			this.Key = -1;
			this.Name = string.Empty;
			this.AmmoPerClip = 1;
			this.TextureKey = -1;
			this.SoundKey = -1;
			this.MuzzleFlashOffsetX = 0f;
			this.MuzzleFlashOffsetY = 0f;
            this.InventorySlot = -1;
			this.SemiAutomatic = true;
			this.FireRecoil = 0f;
			this.TimeBetweenFire = 1;
			this.UnlimitedAmmo = false;
			this.HasMuzzleFlash = false;
			this.AmmoTypeKey = -1;
			this.Damage = 1;
			this.CrosshairTextureKey = -1;
		}


        public override string ToString()
        {
			return this.Name;
        }

    }
}

