﻿using System.Numerics;

namespace RawResources.Models.Levels
{
	public class LightDefinition
	{
		public int Key { get; set; }
		public Vector3 Color { get; set; }
		public float Brightness { get; set; }
		public Vector3 Position { get; set; }


		public LightDefinition()
		{
			this.Key = -1;
			this.Color = new Vector3(0);
			this.Brightness = 100;
			this.Position = new Vector3(0);
		}


		public LightDefinition Clone(LevelDefinition level)
		{
			LightDefinition lightDefinition = new LightDefinition()
			{
				Key = level.GetNewLightKey(),
				Color = this.Color,
				Brightness = this.Brightness,
				Position = this.Position
			};

			return lightDefinition;
        }


		public void Translate(float dx, float dy, float dz)
		{
            this.Position = new Vector3(this.Position.X + dx, this.Position.Y + dy, this.Position.Z + dz);
        }

	}
}

