﻿using System.Numerics;

namespace RawResources.Models.Levels
{
	public enum NodeTypes { StartPoint, TeleportationPoint, Pickup, Enemy, VictoryPoint, Text }


	public class NodeDefinition
	{
		public int Key { get; set; }
        public Vector3 Position { get; set; }
		public NodeTypes NodeType { get; set; }
		public int ChoiceKey { get; set; }
		public string Text { get; set; }


        public NodeDefinition()
		{
			this.Position = new Vector3(0);
			this.NodeType = NodeTypes.StartPoint;
			this.ChoiceKey = -1;
			this.Text = "";
		}


        public override string ToString()
        {
			return Key + " " + NodeType + " (" + Position.X + "," + Position.Y + "," + Position.Z + ")";
        }


        public void Translate(float dx, float dy, float dz)
        {
            this.Position = new Vector3(this.Position.X + dx, this.Position.Y + dy, this.Position.Z + dz);
        }


        public NodeDefinition Clone(LevelDefinition level)
		{
			NodeDefinition nodeDefinition = new NodeDefinition()
			{
				Key = level.GetNewNodeKey(),
				ChoiceKey = this.ChoiceKey,
				NodeType = this.NodeType,
				Position = this.Position,
				Text = this.Text
			};

			return nodeDefinition;
		}

    }
}

