﻿using RawResources.Models;

namespace RawResources.Repositories
{
	public class FilePlayerRepository : IRawContentRepository<PlayerDefinition>
    {
        private IDictionary<int, PlayerDefinition> contentsByKey;
        private IList<int> keys;


        public FilePlayerRepository(string filename)
        {
            this.contentsByKey = new Dictionary<int, PlayerDefinition>();
            this.keys = new List<int>();

            Load(filename);
        }


        public PlayerDefinition? GetContent(int key)
        {
            if (this.contentsByKey.ContainsKey(key))
            {
                return this.contentsByKey[key];
            }

            return null;
        }


        public void RemoveContent(int key)
        {
            if (this.contentsByKey.ContainsKey(key))
            {
                this.contentsByKey.Remove(key);
                this.keys.Remove(key);
            }
        }


        public void AddContent(PlayerDefinition content)
        {
            int key = GetMaxKey() + 1;

            content.Key = key;

            this.contentsByKey.Add(key, content);
            this.keys.Add(key);
        }


        private int GetMaxKey()
        {
            int maxKey = -1;

            foreach (int key in this.keys)
            {
                if (maxKey < key) maxKey = key;
            }

            return maxKey;
        }


        public IEnumerable<PlayerDefinition> GetAllContent()
        {
            IList<PlayerDefinition> content = new List<PlayerDefinition>();
            IEnumerable<int> keys = GetKeys();

            foreach (int key in keys)
            {
                content.Add(contentsByKey[key]);
            }

            return content;
        }


        public IEnumerable<int> GetKeys()
        {
            return this.keys;
        }


        public void Load(string filename)
        {
            Stream stream;
            StreamReader reader;
            string? line = null;
            string[] lineContents;

            try
            {
                stream = File.OpenRead(filename);
                reader = new StreamReader(stream);
            }
            catch (Exception e)
            {
                Console.Error.WriteLine(e.Message);
                return;
            }

            //skip first line
            reader.ReadLine();

            while ((line = reader.ReadLine()) != null)
            {
                lineContents = line.Split('|');

                LoadContent(lineContents);
            }

            reader.Close();
        }


        private void LoadContent(string[] lineContents)
        {
            if (lineContents[0].Equals("") == false)
            {
                PlayerDefinition item = new PlayerDefinition()
                {
                    Key = Int32.Parse(lineContents[0]),
                    StartMapKey = Int32.Parse(lineContents[1]),
                    StartWeaponKey = Int32.Parse(lineContents[2]),
                    StartHealth = Int32.Parse(lineContents[3]),
                    MaxHealth = Int32.Parse(lineContents[4]),
                    StartArmor = Int32.Parse(lineContents[5]),
                    MaxArmor = Int32.Parse(lineContents[6])
                };

                this.contentsByKey.Add(item.Key, item);
                this.keys.Add(item.Key);
            }
        }


        public void Save(string filename)
        {
            StreamWriter writer = new StreamWriter(filename, false);

            writer.WriteLine("Key|StartMapKey|StartWeaponKey|StartHealth|MaxHealth|StartArmor|MaxArmor");

            foreach (int key in this.keys)
            {
                PlayerDefinition definition = this.contentsByKey[key];

                writer.Write(definition.Key);
                writer.Write("|");
                writer.Write(definition.StartMapKey);
                writer.Write("|");
                writer.Write(definition.StartWeaponKey);

                writer.Write("|");
                writer.Write(definition.StartHealth);
                writer.Write("|");
                writer.Write(definition.MaxHealth);
                writer.Write("|");
                writer.Write(definition.StartArmor);
                writer.Write("|");
                writer.Write(definition.MaxArmor);

                writer.WriteLine("");
            }

            writer.Close();
        }

    }
}

